﻿using System;
using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.GeometricObjects.Nodes
{
    /// <summary>
    /// Node on the lane which is not the start or end node.
    /// </summary>
    [Serializable]
    public class InnerNode : Node
    {
        /// <summary>
        /// Value in interval (0, 1) determining location on the lane.
        /// </summary>
        private double t;

        /// <summary>
        /// Initialization of the inner node.
        /// </summary>
        /// <param name="location">Node location.</param>
        /// <param name="t">Value in interval (0, 1) determining location on the lane.</param>
        public InnerNode(Point location, double t)
            : base(location)
        {
            this.t = t;
        }
    }
}
